/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.ClientPlayerMovement;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.RemotePlayerMovement;
import tictim.paraglider.capabilities.ServerPlayerMovement;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.SyncParaglidingMsg;

@Mod.EventBusSubscriber(modid="paraglider")
public final class ParagliderEventHandler {
    private static final double DEFAULT_PARAGLIDING_SPEED = 0.02599999986588955;
    private static final ResourceLocation MOVEMENT_HANDLER_KEY = new ResourceLocation("paraglider", "paragliding_movement_handler");

    private ParagliderEventHandler() {
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        ServerPlayerMovement m;
        if (event.isCancelable() && event.getHand() == InteractionHand.OFF_HAND && (m = ServerPlayerMovement.of((ICapabilityProvider)event.getPlayer())) != null && m.isParagliding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        original.reviveCaps();
        PlayerMovement m1 = PlayerMovement.of((ICapabilityProvider)original);
        PlayerMovement m2 = PlayerMovement.of((ICapabilityProvider)event.getPlayer());
        if (m1 != null && m2 != null) {
            m1.copyTo(m2);
        }
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerUseItem(LivingEntityUseItemEvent.Tick event) {
        ServerPlayerMovement m;
        if (event.getEntityLiving().m_7655_() == InteractionHand.OFF_HAND && event.getEntityLiving() instanceof Player && (m = ServerPlayerMovement.of((ICapabilityProvider)event.getEntityLiving())) != null && m.isParagliding()) {
            event.getEntityLiving().m_5810_();
        }
    }

    @SubscribeEvent
    public static void onAttachPlayerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player p = (Player)object;
            PlayerMovement m = p instanceof ServerPlayer ? new ServerPlayerMovement((ServerPlayer)p) : (PlayerMovement)DistExecutor.unsafeRunForDist(() -> () -> Client.createPlayerMovement(p), () -> () -> new RemotePlayerMovement(p));
            event.addCapability(MOVEMENT_HANDLER_KEY, (ICapabilityProvider)m);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerMovement h = PlayerMovement.of((ICapabilityProvider)event.player);
        if (h != null) {
            if (event.phase == TickEvent.Phase.END) {
                h.update();
            } else if (h.isParagliding()) {
                double v = ModCfg.paraglidingSpeed();
                event.player.f_20887_ = (float)(0.02599999986588955 * v);
            }
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerMovement h = ServerPlayerMovement.of((ICapabilityProvider)event.getPlayer());
        if (h != null) {
            h.movementNeedsSync = true;
            h.paraglidingNeedsSync = true;
            h.vesselNeedsSync = true;
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PlayerMovement h = PlayerMovement.of((ICapabilityProvider)event.getTarget());
            if (h != null) {
                SyncParaglidingMsg msg = new SyncParaglidingMsg(h);
                if (ModCfg.traceParaglidingPacket()) {
                    ParagliderMod.LOGGER.debug("Sending packet {} from player {} to player {}", (Object)msg, (Object)h.player, (Object)player);
                }
                ModNet.NET.send(PacketDistributor.PLAYER.with(() -> sp), (Object)msg);
            }
        }
    }

    private static final class Client {
        private Client() {
        }

        public static PlayerMovement createPlayerMovement(Player player) {
            return player instanceof LocalPlayer ? new ClientPlayerMovement(player) : new RemotePlayerMovement(player);
        }
    }
}

